package gov.va.med.mhv.integration.phr.evault.transfer;

import java.util.Date;

/**
 * @author Rob Murtha
 */
public class EmploymentReport {
    Long id;
    Long userProfileId;
    Long oplock;
    Date createdDate;
    Date modifiedDate;
    Date updatedDate;
    String report;

    public EmploymentReport() {
    }

    public EmploymentReport(long userProfileId, Date updatedDate, String report) {
        this.userProfileId=userProfileId;
        this.updatedDate=updatedDate;
        this.report=report;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }


    public Long getUserProfileId() {

        return userProfileId;
    }

    public void setUserProfileId(Long userProfileId) {
        this.userProfileId = userProfileId;
    }

    public Long getOplock() {
        return oplock;
    }

    public void setOplock(Long oplock) {
        this.oplock = oplock;
    }

    public Date getCreatedDate() {
        return createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public Date getModifiedDate() {
        return modifiedDate;
    }

    public void setModifiedDate(Date modifiedDate) {
        this.modifiedDate = modifiedDate;
    }

    public Date getUpdatedDate() {
        return updatedDate;
    }

    public void setUpdatedDate(Date updatedDate) {
        this.updatedDate = updatedDate;
    }

    public String getReport() {
        return report;
    }

    public void setReport(String report) {
        this.report = report;
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof EmploymentReport)) return false;

        EmploymentReport that = (EmploymentReport) o;

        if (id != that.id) return false;
        if (oplock != that.oplock) return false;
        if (userProfileId != that.userProfileId) return false;
        if (createdDate != null ? !createdDate.equals(that.createdDate) : that.createdDate != null) return false;
        if (modifiedDate != null ? !modifiedDate.equals(that.modifiedDate) : that.modifiedDate != null) return false;
        if (report != null ? !report.equals(that.report) : that.report != null) return false;
        if (updatedDate != null ? !updatedDate.equals(that.updatedDate) : that.updatedDate != null) return false;

        return true;
    }

    @Override
    public int hashCode() {
        int result = (int) (id ^ (id >>> 32));
        result = 31 * result + (int) (userProfileId ^ (userProfileId >>> 32));
        result = 31 * result + (int) (oplock ^ (oplock >>> 32));
        result = 31 * result + (createdDate != null ? createdDate.hashCode() : 0);
        result = 31 * result + (modifiedDate != null ? modifiedDate.hashCode() : 0);
        result = 31 * result + (updatedDate != null ? updatedDate.hashCode() : 0);
        result = 31 * result + (report != null ? report.hashCode() : 0);
        return result;
    }


    @Override
    public String toString() {
        return "EmploymentReport{" +
                "id=" + id +
                ", userProfileId=" + userProfileId +
                ", oplock=" + oplock +
                ", createdDate=" + createdDate +
                ", modifiedDate=" + modifiedDate +
                ", updatedDate=" + updatedDate +
                ", report='" + report + '\'' +
                '}';
    }
}
